DROP VIEW ADR.ACTIVEAGG_VW;

/* Formatted on 7/30/2018 10:56:03 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.ACTIVEAGG_VW
(
   PERID,
   ICN,
   EDIPI,
   SSN,
   LN,
   FN,
   MN,
   SUF,
   DOB,
   DOD,
   GENDER,
   ENR_DTE,
   CV_ELIG,
   ELIG_VERIFIED,
   ENR_CODE,
   PRIORITY,
   ENR_CRE_DTE,
   ADD_TYPE,
   BAI,
   ADDRESS_ID,
   ST1,
   ST2,
   ST3,
   CITY,
   STATE,
   ZIP,
   ZIP4,
   COUNTRY,
   ADT,
   PFA,
   PCF,
   HPN,
   CPN,
   WPN,
   APN,
   TSTART,
   TEND,
   PF_NO,
   PF_NAME,
   VCE,
   SCI,
   SC_PCT,
   SAI,
   SALIST,
   NSCI,
   NLE_ES,
   STA_VISN,
   STA_NO,
   STA_NAME,
   EE_FLAG,
   DISTANCE,
   OPP_FLAG,
   ADR_LON,
   ADR_LAT,
   STA_ST1,
   STA_ST2,
   STA_ST3,
   STA_CITY,
   STA_STATE,
   STA_ZIP,
   STA_ZIP4,
   STA_LON,
   STA_LAT,
   LOC_NAME,
   GEO_DATE,
   SOFTWARE_VER,
   STATUS,
   STATUS_DATE,
   WT_INFO_CONCATTED,
   MAILING_EXCEPTION,
   TIME_COHORT,
   BASIC_ELIG,
   GEO_TIME_FRAME_BEGIN,
   GEO_TIME_FRAME_END,
   WT_RUN_TIME,
   VBA_DOD,
   EVER_GEO_CODED,
   CALC_TYPE,
   DD_BASIC_ELIG,
   DD_NLE_ES,
   VISN,
   URH,
   FIPS,
   MARKET,
   SUBMARKET,
   SECTOR,
   STATE_FIPS,
   S_CLASS_NAME,
   OUTPATIENTRATING,
   PAR_STA_NO,
   PARENTSTATIONCL,
   SH_PAR_STA,
   VA_SITE,
   ST,
   POD,
   SHAR,
   HCC,
   MSCBOC,
   NEWVAMC,
   PCCBOC,
   COCCLASSIFICATIONID,
   VAH,
   CD,
   CONT,
   PROV,
   VACAA_LIST_DATE,
   NLE_ES_DATE,
   COUNTY_NAME,
   MARKET_NAME,
   DATASOURCE,
   DISTRICT,
   STA_DISTRICT_VISN,
   RECORD_CREATED_TS
)
AS
   SELECT PERID,
          ICN,
          EDIPI,
          SSN,
          LN,
          FN,
          MN,
          SUF,
          DOB,
          DOD,
          GENDER,
          ENR_DTE,
          CV_ELIG,
          ELIG_VERIFIED,
          ENR_CODE,
          PRIORITY,
          ENR_CRE_DTE,
          ADD_TYPE,
          BAI,
          ADDRESS_ID,
          ST1,
          ST2,
          ST3,
          CITY,
          STATE,
          ZIP,
          ZIP4,
          COUNTRY,
          ADT,
          PFA,
          PCF,
          HPN,
          CPN,
          WPN,
          APN,
          TSTART,
          TEND,
          PF_NO,
          PF_NAME,
          VCE,
          SCI,
          SC_PCT,
          SAI,
          SALIST,
          NSCI,
          NLE_ES,
          STA_VISN,
          STA_NO,
          STA_NAME,
          EE_FLAG,
          DISTANCE,
          OPP_FLAG,
          ADR_LON,
          ADR_LAT,
          STA_ST1,
          STA_ST2,
          STA_ST3,
          STA_CITY,
          STA_STATE,
          STA_ZIP,
          STA_ZIP4,
          STA_LON,
          STA_LAT,
          LOC_NAME,
          GEO_DATE,
          SOFTWARE_VER,
          STATUS,
          STATUS_DATE,
          WT_INFO_CONCATTED,
          MAILING_EXCEPTION,
          TIME_COHORT,
          BASIC_ELIG,
          GEO_TIME_FRAME_BEGIN,
          GEO_TIME_FRAME_END,
          WT_RUN_TIME,
          VBA_DOD,
          EVER_GEO_CODED,
          CALC_TYPE,
          DD_BASIC_ELIG,
          DD_NLE_ES,
          VISN,
          URH,
          FIPS,
          MARKET,
          SUBMARKET,
          SECTOR,
          STATE_FIPS,
          S_CLASS_NAME,
          OUTPATIENTRATING,
          PAR_STA_NO,
          PARENTSTATIONCL,
          SH_PAR_STA,
          VA_SITE,
          ST,
          POD,
          SHAR,
          HCC,
          MSCBOC,
          NEWVAMC,
          PCCBOC,
          COCCLASSIFICATIONID,
          VAH,
          CD,
          CONT,
          PROV,
          VACAA_LIST_DATE,
          NLE_ES_DATE,
          COUNTY_NAME,
          MARKET_NAME,
          DATASOURCE,
          DISTRICT,
          STA_DISTRICT_VISN,
          s.RECORD_CREATED_TS
     FROM ADR.ACTIVEAGG s,
          (SELECT CASE
                     WHEN LOADING_STATUS = 'YES' THEN CURRENT_ACTIVE_DATE
                     WHEN LOADING_STATUS = 'FAIL' THEN PREVIOUS_ACTIVE_DATE
                     ELSE NULL
                  END
                     active_dt
             FROM ADR.ActiveAGG_TRACKER) t
    WHERE TRUNC (s.RECORD_CREATED_TS) = TRUNC (t.active_dt);


CREATE OR REPLACE PUBLIC SYNONYM ACTIVEAGG_VW FOR ADR.ACTIVEAGG_VW;


GRANT SELECT ON ADR.ACTIVEAGG_VW TO ADR_R;

GRANT SELECT ON ADR.ACTIVEAGG_VW TO EEUSR;
DROP VIEW ADR.CCN_SERVICE_LOG_LOAD_VW;

/* Formatted on 7/30/2018 10:56:04 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.CCN_SERVICE_LOG_LOAD_VW
(
   SERVICE_LOG_STAT_ID,
   PERSON_ID,
   FIRST_NAME,
   LAST_NAME,
   MID_NAME,
   SUFFIX,
   DATE_OF_BIRTH_TXT,
   DATE_OF_DEATH,
   BIRTH_SEX,
   MAILING_ADDRESS_H_ID,
   EMAIL,
   VCELIGIBILITY_H_ID,
   HPHONE_NUM,
   CPHONE_NUM,
   TPHONE_NUM,
   VISN_GEO,
   RESI_ADDRESS_H_ID,
   PREFERRED_FACILITY_H_ID,
   GEOCODE_STATION_H_ID,
   ADDR_RECORD_MODIFIED_DATE,
   VCELIGBTY_RECORD_MODIFIED_DATE,
   SVL_RECORD_MODIFIED_DATE
)
AS
   SELECT /*+ PARALLEL (4) */
         CASE
             WHEN sl.CCN_SERVICE_LOG_ID IS NULL THEN 0
             WHEN sl.CCN_SERVICE_LOG_ID IS NOT NULL THEN CCN_SERVICE_LOG_ID
          END
             service_log_stat_id,
          per.person_id,
          per.first_name,
          per.last_name,
          per.middle_name mid_name,
          per.suffix,
          per.date_of_birth DATE_OF_BIRTH_TXT,
          per.death_date_txt date_of_death,
          per.gender_code birth_sex,
          addrh.mailing_address_h_id,
          em.email_address email,
          per.VCELIGIBILITY_H_ID,
          ph.hphone_num,
          ph.cphone_num,
          ph.tphone_num,
          geot.visn_geo,
          addrh.resi_address_h_id,
          prf.preferred_facility_h_id,
          geot.GEOCODE_STATION_H_ID,
          addr.addr_record_modified_date,
          per.vceligbty_record_modified_date,
          sl.record_modified_date svl_record_modified_date
     FROM ADR.CCN_PERSON_SELECTED_STG per
          INNER JOIN adr.CCN_ADDRESS_STG addr
             ON per.person_id = addr.person_id
          LEFT OUTER JOIN ADR.CCN_ADDRESS_H_STG addrh
             ON addrh.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_PREFERED_FACILITY_H_STG prf
             ON prf.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_EMAIL_STG em
             ON em.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_GEOCODE_TRANSMIT_STG geot
             ON geot.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_PHONE_STG ph
             ON ph.person_id = per.person_id
          LEFT OUTER JOIN CCN_SERVICE_LOG sl
             ON     sl.person_id = per.person_id
                AND sl.TRANSMISSION_TYPE_ID = 1
                AND sl.TRANSMISSION_STTYPE_ID = 2000590;


CREATE OR REPLACE PUBLIC SYNONYM CCN_SERVICE_LOG_LOAD_VW FOR ADR.CCN_SERVICE_LOG_LOAD_VW;


GRANT SELECT ON ADR.CCN_SERVICE_LOG_LOAD_VW TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_SERVICE_LOG_LOAD_VW TO ADR_RW;
